<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('apps', function (Blueprint $table) {
            // Custom CSS and JavaScript
            $table->longText('custom_css')
                ->nullable()
                ->after('drawer_text_theme');
            $table->longText('custom_js')
                ->nullable()
                ->after('custom_css');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('apps', function (Blueprint $table) {
            $table->dropColumn(['custom_css', 'custom_js']);
        });
    }
};
